/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsBaseContext;
import com.floragunn.searchguard.enterprise.dlsfls.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.RoleBasedFieldAuthorization;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlsFieldFilter
implements Function<String, Predicate<String>>,
ComponentStateProvider {
    private static final String KEYWORD = ".keyword";
    private static final Logger log = LogManager.getLogger(FlsFieldFilter.class);
    private final DlsFlsBaseContext baseContext;
    private final AtomicReference<DlsFlsProcessedConfig> config;
    private final ComponentState componentState = new ComponentState(1, null, "fls_field_filter", FlsFieldFilter.class).initialized();
    private final TimeAggregation applyAggregation = new TimeAggregation.Nanoseconds();

    FlsFieldFilter(DlsFlsBaseContext baseContext, AtomicReference<DlsFlsProcessedConfig> config) {
        this.baseContext = baseContext;
        this.config = config;
        this.componentState.addMetrics("filter_fields", (Measurement)this.applyAggregation);
    }

    @Override
    public Predicate<String> apply(String index) {
        Predicate<String> predicate;
        block13: {
            DlsFlsProcessedConfig config = this.config.get();
            if (!config.isEnabled()) {
                return field -> true;
            }
            PrivilegesEvaluationContext privilegesEvaluationContext = this.baseContext.getPrivilegesEvaluationContext();
            if (privilegesEvaluationContext == null) {
                return field -> true;
            }
            Meter meter = Meter.detail((MetricsLevel)config.getMetricsLevel(), (Measurement)this.applyAggregation);
            try {
                RoleBasedFieldAuthorization fieldAuthorization = config.getFieldAuthorization();
                if (fieldAuthorization == null) {
                    throw new IllegalStateException("FLS is not initialized");
                }
                if (privilegesEvaluationContext.getSpecialPrivilegesEvaluationContext() != null && privilegesEvaluationContext.getSpecialPrivilegesEvaluationContext().getRolesConfig() != null) {
                    SgDynamicConfiguration roles = privilegesEvaluationContext.getSpecialPrivilegesEvaluationContext().getRolesConfig();
                    fieldAuthorization = new RoleBasedFieldAuthorization((SgDynamicConfiguration<Role>)roles, (Set<String>)ImmutableSet.of((Object)index), MetricsLevel.NONE);
                }
                RoleBasedFieldAuthorization.FlsRule flsRule = fieldAuthorization.getFlsRule(privilegesEvaluationContext, index, meter);
                predicate = field -> flsRule.isAllowed(FlsFieldFilter.removeSuffix(field));
                if (meter == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (meter != null) {
                        try {
                            meter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PrivilegesEvaluationException e) {
                    log.error("Error while evaluating FLS for index " + index, (Throwable)e);
                    this.componentState.addLastException("filter_fields", (Throwable)e);
                    throw new RuntimeException("Error while evaluating FLS for index " + index, e);
                }
                catch (RuntimeException e) {
                    log.error("Error while evaluating FLS for index " + index, (Throwable)e);
                    this.componentState.addLastException("filter_fields", (Throwable)e);
                    throw e;
                }
            }
            meter.close();
        }
        return predicate;
    }

    private static String removeSuffix(String field) {
        if (field != null && field.endsWith(KEYWORD)) {
            return field.substring(0, field.length() - KEYWORD.length());
        }
        return field;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

